using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1201.BaseCMS.BL.DBD
{
    internal class WebPage : PI.WA.N300.WebPageManager.BL.DBD.WebPage
    {
        #region Static factory
        private static WebPage _factory = null;
        public static new WebPage DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new WebPage();
                }
                return _factory;
            }
        }
        #endregion

        /// <summary>
        /// Dodatkowe metody dostpu dla LA
        /// </summary>
        public enum ExtendedCommands
        {
            RestoreChildListOrderByDatePages = 101,
            CountChildListOrderByDatePages = 102,
        }

        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)ExtendedCommands.RestoreChildListOrderByDatePages: return new Command_RestoreChildListOrderByDatePages();
                case (int)ExtendedCommands.CountChildListOrderByDatePages: return new Command_CountChildListOrderByDatePages();
            }
            return base.DoGetCommand(CommandID);
        }

        internal class Command_RestoreChildListOrderByDatePages : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.WA.N300.WebPageManager.BL.BO.WebPage>
        {
            public Command_RestoreChildListOrderByDatePages() : base(PI.WA.N300.WebPageManager.BL.DBD.WebPage.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("PageSize", Gemini.Core.BL.DAL.SqlTypes.Int));
                Add(new Gemini.Core.BL.DBD.Param("PageNumber", Gemini.Core.BL.DAL.SqlTypes.Int));
                Add(new Gemini.Core.BL.DBD.Param("WebPageParentID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Flags", Gemini.Core.BL.DAL.SqlTypes.Int));
                Add(new Gemini.Core.BL.DBD.Param("IsNode", Gemini.Core.BL.DAL.SqlTypes.Bit));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIWA300_WebPage_RestoreChildListOrderByDatePages";
            }
        }

        internal class Command_CountChildListOrderByDatePages : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.WA.N300.WebPageManager.BL.BO.WebPage>
        {
            public Command_CountChildListOrderByDatePages() : base(PI.WA.N300.WebPageManager.BL.DBD.WebPage.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("WebPageParentID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Flags", Gemini.Core.BL.DAL.SqlTypes.Int));
                Add(new Gemini.Core.BL.DBD.Param("IsNode", Gemini.Core.BL.DAL.SqlTypes.Bit));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.Int, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIWA300_WebPage_CountChildListOrderByDatePages";
            }
        }
    }
}
